using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class TMDS_StagingDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public TMDS_StagingDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public TMDS_Staging GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string ASSESSMENT)
		{
			TMDS_Staging objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_TMDS_Staging_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, ASSESSMENT).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<TMDS_Staging> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<TMDS_Staging> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_TMDS_Staging_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public string Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, TMDS_Staging objSave)
		{
			string objReturn = objSave.ASSESSMENT;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_TMDS_Staging_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.ADDRESS_LINE1, objSave.ADDRESS_LINE2, ref objReturn, objSave.ASSESSMENT_KEYWORDS, objSave.CDA, objSave.CITY, objSave.COUNTRY, objSave.DEATH_DATE, objSave.DEPLOYED, objSave.DISPOSITION_DESCR, objSave.DOB, objSave.DX1, objSave.DX10, objSave.DX11, objSave.DX12, objSave.DX13, objSave.DX14, objSave.DX15, objSave.DX16, objSave.DX17, objSave.DX18, objSave.DX19, objSave.DX2, objSave.DX20, objSave.DX3, objSave.DX4, objSave.DX5, objSave.DX6, objSave.DX7, objSave.DX8, objSave.DX9, objSave.ENCOUNTER_DATE, objSave.ETHNICITY, objSave.FIRST_NAME, objSave.GENDER, objSave.HOME_PHONE, objSave.ID, objSave.INJURY_TYPE, objSave.LAST_NAME, objSave.LONG_DESCR, objSave.MAJOR1, objSave.MAJOR2, objSave.MAJOR3, objSave.MAJOR4, objSave.MAJOR5, objSave.MARITAL_STATUS, objSave.MTF_ADDRESS, objSave.MTF_BRANCH, objSave.MTF_COMMENT, objSave.MTF_LAT, objSave.MTF_LONG, objSave.MTF_THEATER, objSave.OBJECTIVE, objSave.OBJECTIVE_KEYWORDS, objSave.PATSSN, objSave.PAY_GRADE, objSave.PLAN_OF_CARE, objSave.PLAN_OF_CARE_KEYWORDS, objSave.SERVICE_DESCR, objSave.SERVICE_NAME, objSave.STATE, objSave.SUBJECTIVE, objSave.SUBJECTIVE_KEYWORDS, objSave.UIC, objSave.UNIT_NAME, objSave.UNIT_TYPE, objSave.ZIP, objSave.ZIP_Plus_4);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string ASSESSMENT)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_TMDS_Staging_delete(CURRENT_USER, CURRENT_REGISTRY_ID, ASSESSMENT);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
